/* 
 * MTKMemory:  A MTK plugin to monitor memory usage.
 * Copyright (C) 2002-2005 Mike Piatek-Jimenez, Gaucho Software
 * You can view the complete license in the LICENSE file in the root
 * of the source tree.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

//
//  GSMemoryMiner.h
//

#import <Foundation/Foundation.h>
#import <mach/host_info.h>
#import <mach/mach_host.h>
#import <GSFoundation/GSDataSet.h>

@interface GSMemoryMiner : NSObject {
	@private
    int						numSamples;
	
    GSDataSet				*values1;
    GSDataSet				*values2;
    GSDataSet				*values3;
    
    host_name_port_t		host;
    vm_statistics_data_t	currentDiffs;
    vm_statistics_data_t	lastStats;
}

#pragma mark Data Update Methods
- (void)tick;
- (void)getLatestMemoryInfo;

#pragma mark Information Retrieval
- (integer_t)freeBytes;
- (integer_t)activeBytes;
- (integer_t)inactiveBytes;
- (integer_t)wiredBytes;
- (integer_t)totalFaults;
- (integer_t)recentFaults;
- (integer_t)totalPageIns;
- (integer_t)recentPageIns;
- (integer_t)totalPageOuts;
- (integer_t)recentPageOuts;
- (integer_t)totalCacheLookups;
- (integer_t)totalCacheHits;
- (GSDataSet *)faultData;
- (GSDataSet *)pageInData;
- (GSDataSet *)pageOutData;

#pragma mark Class Configuration
- (void)setDataSize:(int)newNumSamples;

@end
